package com.ebookfrenzy.transitiondemo;

import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.transition.TransitionManager;
import android.transition.ChangeBounds;
import android.transition.Transition;
import android.view.animation.BounceInterpolator;

public class TransitionDemoActivity extends AppCompatActivity {

    ViewGroup myLayout;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_transition_demo);

        myLayout = (ViewGroup) findViewById(R.id.myLayout);

        myLayout.setOnTouchListener(
                new RelativeLayout.OnTouchListener() {
                    public boolean onTouch(View v,
                                           MotionEvent m) {
                        handleTouch();
                        return true;
                    }
                }
        );
    }

     public void handleTouch() {
         View view = findViewById(R.id.myButton1);

         Transition changeBounds = new ChangeBounds();
         changeBounds.setDuration(3000);
         changeBounds.setInterpolator(new BounceInterpolator());

         TransitionManager.beginDelayedTransition(myLayout, changeBounds);

         RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT,
            RelativeLayout.LayoutParams.WRAP_CONTENT);

         params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT,
            RelativeLayout.TRUE);
         params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM,
            RelativeLayout.TRUE);
         view.setLayoutParams(params);

         ViewGroup.LayoutParams lparams = view.getLayoutParams();

         lparams.width = 500;
         lparams.height = 350;
         view.setLayoutParams(lparams);
    }


}
