//
//  MyUIView.swift
//  3DTouchForce
//
//  Created by Neil Smyth on 10/5/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class MyUIView: UIView {

    var size:CGFloat = 0

    override func drawRect(rect: CGRect) {
        let view_width = self.bounds.width
        let view_height = self.bounds.height

        let context = UIGraphicsGetCurrentContext()
        let rectangle = CGRectMake(0, view_height - size, view_width, size)
        CGContextAddRect(context, rectangle)
        CGContextSetFillColorWithColor(context,
            UIColor.redColor().CGColor)
        CGContextFillRect(context, rectangle)
    }

    override func touchesBegan(touches: Set<UITouch>, 
                    withEvent event: UIEvent?) {
        handleTouch(touches)
    }

    override func touchesMoved(touches: Set<UITouch>, 
                    withEvent event: UIEvent?) {
        handleTouch(touches)
    }

    override func touchesEnded(touches: Set<UITouch>, 
                    withEvent event: UIEvent?) {
        size = 0
        self.setNeedsDisplay()
    }

    func handleTouch(touches:Set<UITouch>) {
        let touch = touches.first
        size = touch!.force * 100
        self.setNeedsDisplay()
    }


}
