//
//  ViewController.swift
//  AVPlayerDemo
//
//  Created by Neil Smyth on 7/24/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import AVKit
import AVFoundation

class ViewController: UIViewController, AVPlayerViewControllerDelegate {
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    func playerViewControllerWillStartPictureInPicture(playerViewController: AVPlayerViewController) {
    }
    
    func playerViewControllerShouldAutomaticallyDismissAtPictureInPictureStart(playerViewController: AVPlayerViewController) -> Bool {
        return true
    }
    
    func playerViewController(playerViewController: AVPlayerViewController,
        restoreUserInterfaceForPictureInPictureStopWithCompletionHandler
        completionHandler: (Bool) -> Void) {
        
            let currentViewController = navigationController?.visibleViewController
            
            if currentViewController != playerViewController {
                if let topViewController = navigationController?.topViewController {
                    topViewController.presentViewController(playerViewController, animated: true, completion: {()
                    completionHandler(true)
                    })
                }
            }
        }
    

    override func prepareForSegue(segue: UIStoryboardSegue,
		sender: AnyObject?) {
        let destination = segue.destinationViewController as?
				AVPlayerViewController
        let url = NSURL(string: 
                    "http://www.ebookfrenzy.com/ios_book/movie/movie.mov")
        
            destination!.delegate = self
            
            if let movieURL = url {
                destination!.player = AVPlayer(URL: movieURL)
            }
    }


}

