//
//  ActionViewController.swift
//  MyActionExt
//
//  Created by Neil Smyth on 9/5/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import MobileCoreServices

class ActionViewController: UIViewController {


    @IBOutlet weak var myTextView: UITextView!
    var convertedString: String?

    override func viewDidLoad() {
        super.viewDidLoad()
        let textItem = self.extensionContext!.inputItems[0] 
			as! NSExtensionItem
    
        let textItemProvider = textItem.attachments![0]
            as! NSItemProvider

        if textItemProvider.hasItemConformingToTypeIdentifier(
                       kUTTypeText as String) {
            textItemProvider.loadItemForTypeIdentifier(
                kUTTypeText as String,
                options: nil,
                completionHandler: handleCompletion)

        }
    }

    func handleCompletion(string: NSSecureCoding?, error: NSError!)
    {
        convertedString = string as? String

        if convertedString != nil {
            convertedString = convertedString!.uppercaseString

            dispatch_async(dispatch_get_main_queue()) {
                self.myTextView.text = self.convertedString!
            }
        }
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    @IBAction func done() {
        // Return any edited content to the host app.
        // This template doesn't do anything, so we just echo the passed in items.
        let returnProvider =
            NSItemProvider(item: convertedString,
                          typeIdentifier: kUTTypeText as String)

        let returnItem = NSExtensionItem()

        returnItem.attachments = [returnProvider]
        self.extensionContext!.completeRequestReturningItems(
          [returnItem], completionHandler: nil)

    }

}
