//
//  ViewController.swift
//  AudioDemo
//
//  Created by Neil Smyth on 9/8/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import AVFoundation

class ViewController: UIViewController, AVAudioPlayerDelegate {

    @IBOutlet weak var volumeControl: UISlider!
    var audioPlayer: AVAudioPlayer?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        let url = NSURL.fileURLWithPath(
                NSBundle.mainBundle().pathForResource("Moderato", 
                ofType: "mp3")!)

        do {
            try audioPlayer = AVAudioPlayer(contentsOfURL: url)
            audioPlayer?.delegate = self
            audioPlayer?.prepareToPlay()
        } catch let error as NSError {
            print("audioPlayer error \(error.localizedDescription)")
        }
    }

    @IBAction func playAudio(sender: AnyObject) {
        if let player = audioPlayer {
            player.play()
        }
    }
    
    @IBAction func stopAudio(sender: AnyObject) {
        if let player = audioPlayer {
            player.stop()
        }

    }
    
    @IBAction func adjustVolume(sender: AnyObject) {
        if audioPlayer != nil {
            audioPlayer?.volume = volumeControl.value
        }

    }

    func audioPlayerDidFinishPlaying(player: AVAudioPlayer, successfully
            flag: Bool) {
    }

    func audioPlayerDecodeErrorDidOccur(player: AVAudioPlayer,
            error: NSError?) {
    }

    func audioPlayerBeginInterruption(player: AVAudioPlayer) {
    }

    func audioPlayerEndInterruption(player: AVAudioPlayer) {
    }

    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

