//
//  Draw2D.swift
//  Draw2D
//
//  Created by Neil Smyth on 9/3/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class Draw2D: UIView {

    override func drawRect(rect: CGRect) {
        let myimage = UIImage(named: "tree.jpg")
        let cimage = CIImage(image: myimage!)

        let sepiaFilter = CIFilter(name: "CISepiaTone")
        sepiaFilter!.setDefaults()
        sepiaFilter!.setValue(cimage, forKey: "inputImage")
        sepiaFilter!.setValue(NSNumber(float: 0.8), 
            forKey: "inputIntensity")

        let image = sepiaFilter!.outputImage

        let context = CIContext(options: nil)

        let cgImage = context.createCGImage(image!, 
            fromRect: image!.extent)

        let resultImage = UIImage(CGImage: cgImage)
        let imageRect = UIScreen.mainScreen().bounds
        resultImage.drawInRect(imageRect)

    }

}
