//
//  ViewController.swift
//  FileExample
//
//  Created by Neil Smyth on 9/1/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var textBox: UITextField!
    
    var fileMgr: NSFileManager = NSFileManager.defaultManager()
    var docsDir: String?
    var dataFile: String?

    override func viewDidLoad() {
        super.viewDidLoad()

        let filemgr = NSFileManager.defaultManager()

        let dirPaths = filemgr.URLsForDirectory(.DocumentDirectory, inDomains: .UserDomainMask)

        dataFile = dirPaths[0].URLByAppendingPathComponent("datafile.dat").path
        
        if fileMgr.fileExistsAtPath(dataFile!) {
            let databuffer = fileMgr.contentsAtPath(dataFile!)
            let datastring = NSString(data: databuffer!,
				       encoding: NSUTF8StringEncoding)
            textBox.text = datastring as? String
        }


    }

    @IBAction func saveText(sender: AnyObject) {
        let databuffer = (textBox.text)!.dataUsingEncoding(NSUTF8StringEncoding)

        fileMgr.createFileAtPath(dataFile!, contents: databuffer, 
                    attributes: nil)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

