//
//  ViewController.swift
//  FlyoverDemo
//
//  Created by Neil Smyth on 9/18/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import MapKit

class ViewController: UIViewController {

    @IBOutlet weak var mapView: MKMapView!

    let distance: CLLocationDistance = 650
    let pitch: CGFloat = 65
    let heading = 0.0
    var camera: MKMapCamera?

    override func viewDidLoad() {
        super.viewDidLoad()
        
        mapView.mapType = .SatelliteFlyover
        
        let coordinate = CLLocationCoordinate2D(latitude: 40.7484405, longitude: -73.9856644)
        camera = MKMapCamera(lookingAtCenterCoordinate: coordinate, fromDistance: distance, pitch: pitch, heading: heading)
        mapView.camera = camera!
    }

    @IBAction func animateCamera(sender: AnyObject) {
        
        UIView.animateWithDuration(20.0, animations: {
            self.camera!.heading += 180
            self.camera!.pitch = 25
            self.mapView.camera = self.camera!
        })
    }
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

