//
//  PurchaseViewController.swift
//  InAppDemo
//
//  Created by Neil Smyth on 9/9/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import StoreKit

class PurchaseViewController: UIViewController, SKPaymentTransactionObserver, SKProductsRequestDelegate  {


    @IBOutlet weak var productTitle: UILabel!
    @IBOutlet weak var productDescription: UITextView!
    @IBOutlet weak var buyButton: UIButton!
    
    var product: SKProduct?
    var productID = "<YOUR PRODUCT ID GOES HERE>"

    override func viewDidLoad() {
        super.viewDidLoad()
    buyButton.enabled = false
    SKPaymentQueue.defaultQueue().addTransactionObserver(self)
    getProductInfo()


    }

func getProductInfo()
{
    if SKPaymentQueue.canMakePayments() {
        let request = SKProductsRequest(productIdentifiers: 
		NSSet(objects: self.productID) as! Set<String>)
        request.delegate = self
        request.start()
    } else {
        productDescription.text = 
			"Please enable In App Purchase in Settings"
    }
}

func productsRequest(request: SKProductsRequest, didReceiveResponse response: SKProductsResponse) {

    var products = response.products

    if (products.count != 0) {
        product = products[0]
        buyButton.enabled = true
        productTitle.text = product!.localizedTitle
        productDescription.text = product!.localizedDescription

    } else {
            productTitle.text = "Product not found"
    }

    let invalids = response.invalidProductIdentifiers

    for product in invalids
    {
         print("Product not found: \(product)")
    }
}



    @IBAction func buyProduct(sender: AnyObject) {
        let payment = SKPayment(product: product!)
        SKPaymentQueue.defaultQueue().addPayment(payment)

    }

    
func paymentQueue(queue: SKPaymentQueue, updatedTransactions transactions: [SKPaymentTransaction]) {
    for transaction in transactions {
        
        switch transaction.transactionState {
            
        case SKPaymentTransactionState.Purchased:
            self.unlockFeature()
            SKPaymentQueue.defaultQueue().finishTransaction(transaction)
            
        case SKPaymentTransactionState.Failed:
            SKPaymentQueue.defaultQueue().finishTransaction(transaction)
        default:
            break
        }
    }

}
    
    func paymentQueue(queue: SKPaymentQueue, updatedDownloads downloads: [SKDownload]) {
    for download in downloads
    {
        switch download.downloadState {
            case SKDownloadState.Active:
                print("Download progress \(download.progress)")
                print("Download time = \(download.timeRemaining)")
                break
            case SKDownloadState.Finished:
                // Download is complete. Content file URL is at
                // path referenced by download.contentURL. Move                 
                // it somewhere safe, unpack it and give the user
                // access to it
                 break
            default:
                 break
        }
    }

    }
    
func unlockFeature() {
    let appdelegate = UIApplication.sharedApplication().delegate 
				as! AppDelegate

    appdelegate.homeViewController!.enableLevel2()
    buyButton.enabled = false
    productTitle.text = "Item has been purchased"
}

    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
