//
//  TodayViewController.swift
//  MyLocation
//
//  Created by Neil Smyth on 9/4/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import NotificationCenter
import CoreLocation

class TodayViewController: UIViewController, NCWidgetProviding, CLLocationManagerDelegate {
        
    @IBOutlet weak var latitudeLabel: UILabel!
    @IBOutlet weak var longitudeLabel: UILabel!

    var locationManager: CLLocationManager = CLLocationManager()
    var currentLocation: CLLocation?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        locationManager.desiredAccuracy = kCLLocationAccuracyBest
        locationManager.delegate = self
        //locationManager.requestWhenInUseAuthorization()
        locationManager.requestLocation()
    }

    override func viewWillAppear(animated: Bool) {
            performWidgetUpdate()
    }
    
    @IBAction func openApp(sender: AnyObject) {
        let url: NSURL? = NSURL(string: "location:")!

        if let appurl = url {
            self.extensionContext!.openURL(appurl, 
                completionHandler: nil)
        }

    }

    func locationManager(manager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {
        currentLocation = locations[0]
    }

    func locationManager(manager: CLLocationManager, didFailWithError error: NSError) {

        print(error.description)
    }

    func performWidgetUpdate()
    {
         if currentLocation != nil {
             let latitudeText = String(format: "Lat: %.4f",
                            currentLocation!.coordinate.latitude)

             let longitudeText = String(format: "Lon: %.4f",
                            currentLocation!.coordinate.longitude)

             latitudeLabel.text = latitudeText
             longitudeLabel.text = longitudeText
          }
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    func widgetPerformUpdateWithCompletionHandler(completionHandler: ((NCUpdateResult) -> Void)) {
        performWidgetUpdate()
        completionHandler(NCUpdateResult.NewData)
    }
    
}
