//
//  ViewController.swift
//  MapItem
//
//  Created by Neil Smyth on 9/4/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import CoreLocation
import Contacts
import MapKit

class ViewController: UIViewController {

    @IBOutlet weak var address: UITextField!
    @IBOutlet weak var city: UITextField!
    @IBOutlet weak var state: UITextField!
    @IBOutlet weak var zip: UITextField!
    var coords: CLLocationCoordinate2D?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    @IBAction func getDirections(sender: AnyObject) {
        let geoCoder = CLGeocoder()

        let addressString = "\(address.text) \(city.text) \(state.text) \(zip.text)"

        geoCoder.geocodeAddressString(addressString, completionHandler: 
        {(placemarks: [CLPlacemark]?, error: NSError?) in

            if error != nil {
                print("Geocode failed with error: \(error!.localizedDescription)")
            } else if placemarks!.count > 0 {
                let placemark = placemarks![0]
                let location = placemark.location
                self.coords = location!.coordinate

                self.showMap()

            }
        })
    }

    func showMap() {
        let addressDict = 
               [CNPostalAddressStreetKey: address.text!,
                CNPostalAddressCityKey: city.text!,
                CNPostalAddressStateKey: state.text!,
                CNPostalAddressPostalCodeKey: zip.text!]

        let place = MKPlacemark(coordinate: coords!, 
                     addressDictionary: addressDict)

        let mapItem = MKMapItem(placemark: place)

        let options = [MKLaunchOptionsDirectionsModeKey: 
                MKLaunchOptionsDirectionsModeDriving]

        mapItem.openInMapsWithLaunchOptions(options)
    }

    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

