//
//  RouteViewController.swift
//  MapSample
//
//  Created by Neil Smyth on 9/4/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import MapKit

class RouteViewController: UIViewController, MKMapViewDelegate, CLLocationManagerDelegate {

    @IBOutlet weak var routeMap: MKMapView!
    var destination: MKMapItem?
    var locationManager: CLLocationManager = CLLocationManager()
    var userLocation: CLLocation?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        routeMap.delegate = self
        routeMap.showsUserLocation = true
        locationManager.desiredAccuracy = kCLLocationAccuracyBest
        locationManager.delegate = self
        locationManager.requestLocation()
    }

    func locationManager(manager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {

        userLocation = locations[0]
        self.getDirections()
    }

    func locationManager(manager: CLLocationManager, didFailWithError error: NSError) {

        print(error.description)
    }

    func getDirections() {

        let request = MKDirectionsRequest()
        request.source = MKMapItem.mapItemForCurrentLocation()
        request.destination = destination!
        request.requestsAlternateRoutes = false

        let directions = MKDirections(request: request)

        directions.calculateDirectionsWithCompletionHandler({(response: 
            MKDirectionsResponse?, error: NSError?) in

            if error != nil {
                print("Error getting directions")
            } else {
                self.showRoute(response!)
            }

        })
    }

    func showRoute(response: MKDirectionsResponse) {

        for route in response.routes {

            routeMap.addOverlay(route.polyline,
                    level: MKOverlayLevel.AboveRoads)

            for step in route.steps {
                print(step.instructions)
            }
        }
     
        let region = 
         MKCoordinateRegionMakeWithDistance(userLocation!.coordinate, 
                2000, 2000)

        routeMap.setRegion(region, animated: true)
    }

    func mapView(mapView: MKMapView, rendererForOverlay 
        overlay: MKOverlay) -> MKOverlayRenderer {
        let renderer = MKPolylineRenderer(overlay: overlay)

        renderer.strokeColor = UIColor.blueColor()
        renderer.lineWidth = 5.0
        return renderer
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    

    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
