//
//  ViewController.swift
//  PageApp
//
//  Created by Neil Smyth on 8/31/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UIPageViewControllerDataSource, UIPageViewControllerDelegate {

    var pageController: UIPageViewController?
    var pageContent = NSArray()

    override func viewDidLoad() {
        super.viewDidLoad()
        createContentPages()
        pageController = UIPageViewController(
            transitionStyle: .PageCurl, 
            navigationOrientation: .Horizontal, 
            options: nil)

        pageController?.delegate = self
        pageController?.dataSource = self

        let startingViewController: ContentViewController = 
            viewControllerAtIndex(0)!

        let viewControllers: NSArray = [startingViewController]
        pageController!.setViewControllers(viewControllers as? [UIViewController],
            direction: .Forward, 
            animated: false, 
            completion: nil)

        self.addChildViewController(pageController!)
        self.view.addSubview(self.pageController!.view)

        let pageViewRect = self.view.bounds
        pageController!.view.frame = pageViewRect    
        pageController!.didMoveToParentViewController(self)

    }

    func createContentPages() {

        var pageStrings = [String]()

        for i in 1...11
        {
            let contentString = "<html><head></head><body><br><h1>Chapter \(i)</h1><p>This is the page \(i) of content displayed using UIPageViewController in iOS 9.</p></body></html>"
            pageStrings.append(contentString)
        }
        pageContent = pageStrings
    }

    func viewControllerAtIndex(index: Int) -> ContentViewController? {

        if (pageContent.count == 0) || 
        (index >= pageContent.count) {
            return nil
        }

        let storyBoard = UIStoryboard(name: "Main", 
            bundle: NSBundle.mainBundle())
        let dataViewController = storyBoard.instantiateViewControllerWithIdentifier("contentView") as! ContentViewController

        dataViewController.dataObject = pageContent[index]
        return dataViewController
    }

    func indexOfViewController(viewController: ContentViewController) -> Int {

        if let dataObject: AnyObject = viewController.dataObject {
            return pageContent.indexOfObject(dataObject)
        } else {
            return NSNotFound
        }
    }

    func pageViewController(pageViewController: UIPageViewController, viewControllerBeforeViewController viewController: UIViewController) -> UIViewController? {

        var index = indexOfViewController(viewController 
                    as! ContentViewController)

        if (index == 0) || (index == NSNotFound) {
            return nil
        }

        index -= 1
        return viewControllerAtIndex(index)
    }

    func pageViewController(pageViewController: UIPageViewController, viewControllerAfterViewController viewController: UIViewController) -> UIViewController? {

        var index = indexOfViewController(viewController 
        as! ContentViewController)

        if index == NSNotFound {
            return nil
        }

        index += 1
        if index == pageContent.count {
            return nil
        }
        return viewControllerAtIndex(index)
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

