//
//  PhotoEditingViewController.swift
//  MyPhotoExt
//
//  Created by Neil Smyth on 9/5/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import Photos
import PhotosUI

class PhotoEditingViewController: UIViewController, PHContentEditingController {

    var input: PHContentEditingInput?
    var displayedImage: UIImage?
    var imageOrientation: Int32?
    var currentFilter = "CIColorInvert"

    @IBOutlet weak var imageView: UIImageView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
    }

    @IBAction func sepiaSelected(sender: AnyObject) {
        currentFilter = "CISepiaTone"

        if displayedImage != nil {
            imageView.image = performFilter(displayedImage!, 
					orientation: nil)
        }
    }
    
    @IBAction func monoSelected(sender: AnyObject) {
        currentFilter = "CIPhotoEffectMono"

        if displayedImage != nil {
            imageView.image = performFilter(displayedImage!, 
					orientation: nil)
        }
    }
    
    @IBAction func invertSelected(sender: AnyObject) {
        currentFilter = "CIColorInvert"

        if displayedImage != nil {
            imageView.image = performFilter(displayedImage!, 
					orientation: nil)
        }
    }

    func performFilter(inputImage: UIImage, orientation: Int32?)
                        -> UIImage?
    {
        var resultImage: UIImage?
        var cimage: CIImage
        cimage = CIImage(image: inputImage)!

        if orientation != nil {
            cimage = cimage.imageByApplyingOrientation(orientation!)
        }

        if let filter = CIFilter(name: currentFilter) {
            filter.setDefaults()
            filter.setValue(cimage, forKey: "inputImage")

            switch currentFilter {

                case "CISepiaTone", "CIEdges":
                    filter.setValue(0.8, forKey: "inputIntensity")

                case "CIMotionBlur":
                    filter.setValue(25.00, forKey:"inputRadius")
                    filter.setValue(0.00, forKey:"inputAngle")

                default:
                    break
            }

            let ciFilteredImage = filter.outputImage
            let context = CIContext(options: nil)
            let cgImage = context.createCGImage(ciFilteredImage!,
                        fromRect: ciFilteredImage!.extent)
            resultImage = UIImage(CGImage: cgImage)
        }
        return resultImage
    }

    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    // MARK: - PHContentEditingController

    func canHandleAdjustmentData(adjustmentData: PHAdjustmentData?) -> Bool {
        // Inspect the adjustmentData to determine whether your extension can work with past edits.
        // (Typically, you use its formatIdentifier and formatVersion properties to do this.)
        return false
    }

    func startContentEditingWithInput(contentEditingInput: PHContentEditingInput?, placeholderImage: UIImage) {
        input = contentEditingInput
        if input != nil {
            displayedImage = input!.displaySizeImage
            imageOrientation = input!.fullSizeImageOrientation
            imageView.image = displayedImage
        }

    }

    func finishContentEditingWithCompletionHandler(completionHandler: ((PHContentEditingOutput!) -> Void)!) {
        // Update UI to reflect that editing has finished and output is being rendered.
        
        // Render and provide output on a background queue.
        dispatch_async(dispatch_get_global_queue(CLong(DISPATCH_QUEUE_PRIORITY_DEFAULT), 0)) {
            // Create editing output from the editing input.
            let output = PHContentEditingOutput(contentEditingInput: self.input!)
            
            // Provide new adjustments and render output to given location.
            // output.adjustmentData = <#new adjustment data#>
            // let renderedJPEGData = <#output JPEG#>
            // renderedJPEGData.writeToURL(output.renderedContentURL, atomically: true)
            
            let url = self.input?.fullSizeImageURL

            if let imageUrl = url {
                let fullImage = UIImage(contentsOfFile: 
                    imageUrl.path!)

                let resultImage = self.performFilter(fullImage!,
                    orientation: self.imageOrientation)

                if let renderedJPEGData =
                    UIImageJPEGRepresentation(resultImage!, 0.9) {

                        
                    renderedJPEGData.writeToURL(
                    output.renderedContentURL,
                            atomically: true)
                }
                let archivedData = 
                NSKeyedArchiver.archivedDataWithRootObject(
                    self.currentFilter)

                let adjustmentData = 
                PHAdjustmentData(formatIdentifier:
                            "com.ebookfrenzy.photoext", 
                    formatVersion: "1.0",
                            data: archivedData)

                output.adjustmentData = adjustmentData
            }

            // Call completion handler to commit edit to Photos.
            completionHandler?(output)
            
            // Clean up temporary files, etc.
        }
    }

    var shouldShowCancelConfirmation: Bool {
        // Determines whether a confirmation to discard changes should be shown to the user on cancel.
        // (Typically, this should be "true" if there are any unsaved changes.)
        return false
    }

    func cancelContentEditing() {
        // Clean up temporary files, etc.
        // May be called after finishContentEditingWithCompletionHandler: while you prepare output.
    }

}
