//
//  AppDelegate.swift
//  QuickActions
//
//  Created by Neil Smyth on 10/5/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {

    var window: UIWindow?


    func application(application: UIApplication, didFinishLaunchingWithOptions launchOptions: [NSObject: AnyObject]?) -> Bool {

       let shortcut2 = UIMutableApplicationShortcutItem(type: "SearchMusic",
                localizedTitle: "Search",
                localizedSubtitle: "Find a track to play",
                icon: UIApplicationShortcutIcon(type: .Search),
                userInfo: nil
        )

        let shortcut3 = UIMutableApplicationShortcutItem(type: "AddMusic",
                localizedTitle: "Add Track",
                localizedSubtitle: "Add track to playlist",
                icon: UIApplicationShortcutIcon(type: .Add),
                userInfo: nil
        )

        application.shortcutItems = [shortcut2, shortcut3]

        return true
    }

    func application(application: UIApplication, performActionForShortcutItem shortcutItem: UIApplicationShortcutItem, completionHandler: Bool -> Void) {
        switch (shortcutItem.type) {
            case "PlayMusic" :
                notifyUser(shortcutItem.localizedTitle)
            case "PauseMusic" :
                notifyUser(shortcutItem.localizedTitle)
            case "SearchMusic" :
                notifyUser(shortcutItem.localizedTitle)
            case "AddMusic" :
                notifyUser(shortcutItem.localizedTitle)
            default:
                break
        }
        completionHandler(true)
    }

    func notifyUser(message: String) {

        let alertController = UIAlertController(title: "Quick Action", 
                        message: message, 
                        preferredStyle: .Alert)
        let okAction = UIAlertAction(title: "OK", 
                        style: .Default, 
                        handler: nil)

        alertController.addAction(okAction)

        window!.rootViewController?.presentViewController(alertController, 
                animated: true, completion: nil)
    }


    func applicationWillResignActive(application: UIApplication) {
        // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
        // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
    }

    func applicationDidEnterBackground(application: UIApplication) {
        // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
        // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    }

    func applicationWillEnterForeground(application: UIApplication) {
        // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
    }

    func applicationDidBecomeActive(application: UIApplication) {
        // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    }

    func applicationWillTerminate(application: UIApplication) {
        // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    }


}

