//
//  ViewController.swift
//  Recognizer
//
//  Created by Neil Smyth on 9/2/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var statusLabel: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    @IBAction func tapDetected(sender: UITapGestureRecognizer) {
    statusLabel.text = "Double Tap"
    }
    
    @IBAction func pinchDetected(sender: UIPinchGestureRecognizer) {
     let scale = sender.scale
    let velocity = sender.velocity
    let resultString = 
        "Pinch - scale = \(scale), velocity = \(velocity)"

    statusLabel.text = resultString

    }
    
    @IBAction func rotationDetected(sender: UIRotationGestureRecognizer) {

    let radians = sender.rotation
    let velocity = sender.velocity
    let resultString = 
        "Rotation - Radians = \(radians), velocity = \(velocity)"

    statusLabel.text = resultString
    }
    
    @IBAction func swipeDetected(sender: UISwipeGestureRecognizer) {
    statusLabel.text = "Right swipe"
    }
    
    @IBAction func longPressDetected(sender: UILongPressGestureRecognizer) {
    statusLabel.text = "Long Press" 
   }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

