//
//  ViewController.swift
//  Record
//
//  Created by Neil Smyth on 9/8/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import AVFoundation

class ViewController: UIViewController, AVAudioPlayerDelegate, AVAudioRecorderDelegate {

    var audioPlayer: AVAudioPlayer?
    var audioRecorder: AVAudioRecorder?

    @IBOutlet weak var recordButton: UIButton!
    @IBOutlet weak var stopButton: UIButton!
    @IBOutlet weak var playButton: UIButton!
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        playButton.enabled = false
        stopButton.enabled = false

        let fileMgr = NSFileManager.defaultManager()
        let dirPaths = fileMgr.URLsForDirectory(.DocumentDirectory, inDomains: .UserDomainMask)
        let soundFileURL = dirPaths[0].URLByAppendingPathComponent("sound.caf")
        print(soundFileURL.path)
        let recordSettings = 
            [AVEncoderAudioQualityKey: AVAudioQuality.Min.rawValue,
                    AVEncoderBitRateKey: 16,
                    AVNumberOfChannelsKey: 2,
                    AVSampleRateKey: 44100.0]

        let audioSession = AVAudioSession.sharedInstance()
        
        do {
                try audioSession.setCategory(AVAudioSessionCategoryPlayAndRecord)
        } catch let error as NSError {
            print("audioSession error: \(error.localizedDescription)")
        }

        do {
            
            try audioRecorder = AVAudioRecorder(URL: soundFileURL,
                settings: recordSettings as! [String : AnyObject])
            audioRecorder?.prepareToRecord()
        } catch let error as NSError {
            print("audioSession error: \(error.localizedDescription)")
        }
    }

    @IBAction func recordAudio(sender: AnyObject) {
        if audioRecorder?.recording == false {
            playButton.enabled = false
            stopButton.enabled = true
            audioRecorder?.record()
        }
    }

    @IBAction func stopAudio(sender: AnyObject) {
        stopButton.enabled = false
        playButton.enabled = true
        recordButton.enabled = true

        if audioRecorder?.recording == true {
            audioRecorder?.stop()
        } else {
            audioPlayer?.stop()
        }
    }

    @IBAction func playAudio(sender: AnyObject) {
        
        if audioRecorder?.recording == false {
            stopButton.enabled = true
            recordButton.enabled = false

            do {
                try audioPlayer = AVAudioPlayer(contentsOfURL: (audioRecorder?.url)!)
                audioPlayer!.delegate = self
                audioPlayer!.prepareToPlay()
                audioPlayer!.play()
            } catch let error as NSError {
                print("audioPlayer error: \(error.localizedDescription)")
            }
        }
    }

    func audioPlayerDidFinishPlaying(player: AVAudioPlayer, successfully flag: Bool) {
        recordButton.enabled = true
        stopButton.enabled = false
    }

    func audioPlayerDecodeErrorDidOccur(player: AVAudioPlayer, error: NSError?) {
        print("Audio Play Decode Error")
    }

    func audioRecorderDidFinishRecording(recorder: AVAudioRecorder, successfully flag: Bool) {
    }

    func audioRecorderEncodeErrorDidOccur(recorder: AVAudioRecorder, error: NSError?) {
        print("Audio Record Encode Error")
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

