//
//  FirstViewController.swift
//  ReminderApp
//
//  Created by Neil Smyth on 9/8/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import EventKit

class FirstViewController: UIViewController {

    @IBOutlet weak var reminderText: UITextField!
    @IBOutlet weak var myDatePicker: UIDatePicker!
    let appDelegate = UIApplication.sharedApplication().delegate as! AppDelegate
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    @IBAction func setReminder(sender: AnyObject) {

        if appDelegate.eventStore == nil {
            appDelegate.eventStore = EKEventStore()
            
            appDelegate.eventStore?.requestAccessToEntityType(
               EKEntityType.Reminder, completion: {(granted, error) in
                if !granted {
                    print("Access to store not granted")
                    print(error?.localizedDescription)
                } else {
                        print("Access granted")
                }
            })
        }

        if (appDelegate.eventStore != nil) {
            self.createReminder()
        }

    }

    func createReminder() {

        let reminder = EKReminder(eventStore: appDelegate.eventStore!)

        reminder.title = reminderText.text!
        reminder.calendar = 
        appDelegate.eventStore!.defaultCalendarForNewReminders()
        let date = myDatePicker.date
        let alarm = EKAlarm(absoluteDate: date)

        reminder.addAlarm(alarm)

        do {
            try appDelegate.eventStore?.saveReminder(reminder,
                commit: true)
        } catch let error as NSError {
                print("Reminder failed with error \(error.localizedDescription)")
        }
    }

    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
        reminderText.endEditing(true)
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

