//
//  SecondViewController.swift
//  ReminderApp
//
//  Created by Neil Smyth on 9/8/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import EventKit
import CoreLocation

class SecondViewController: UIViewController, CLLocationManagerDelegate {

    @IBOutlet weak var locationText: UITextField!
    let appDelegate = UIApplication.sharedApplication().delegate as! AppDelegate
    var locationManager: CLLocationManager = CLLocationManager()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        locationManager.requestWhenInUseAuthorization()
        locationManager.delegate = self
        locationManager.distanceFilter = kCLDistanceFilterNone
        locationManager.desiredAccuracy = kCLLocationAccuracyBest
    }

    @IBAction func setLocationReminder(sender: AnyObject) {
        
        if appDelegate.eventStore == nil {
            appDelegate.eventStore = EKEventStore()

            appDelegate.eventStore?.requestAccessToEntityType(
          EKEntityType.Reminder, completion:
            {(granted: Bool, error:NSError?) in
                if !granted {
                    print("Access to store not granted")
                } else {
                    print("Access granted")
                }
            })
        }

        if (appDelegate.eventStore != nil) {
            locationManager.requestLocation()
        }

    }

    func locationManager(manager: CLLocationManager, didUpdateLocations locations: [CLLocation]) {

        let reminder = EKReminder(eventStore: appDelegate.eventStore!)
        reminder.title = locationText.text!
        reminder.calendar = 
             appDelegate.eventStore!.defaultCalendarForNewReminders()

        let location = EKStructuredLocation(title: "Current Location")
        location.geoLocation = locations.last

        let alarm = EKAlarm()

        alarm.structuredLocation = location
        alarm.proximity = EKAlarmProximity.Leave

        reminder.addAlarm(alarm)

        do {
            try appDelegate.eventStore?.saveReminder(reminder,
        commit: true)
        } catch let error as NSError {
            print("Reminder failed with error \(error.localizedDescription)")
        }
    }

    func locationManager(manager: CLLocationManager, didFailWithError error: NSError) {
        print("Failed to get current location: \(error.localizedDescription)")
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}
