//
//  ViewController.swift
//  SocialApp
//
//  Created by Neil Smyth on 9/8/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import Social
import MobileCoreServices

class ViewController: UIViewController, UIImagePickerControllerDelegate, UINavigationControllerDelegate {

    @IBOutlet weak var postText: UITextView!
    @IBOutlet weak var postImage: UIImageView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    @IBAction func selectImage(sender: AnyObject) {
        let imagePicker = UIImagePickerController()
        imagePicker.delegate = self
        imagePicker.sourceType = 
            UIImagePickerControllerSourceType.PhotoLibrary
        imagePicker.mediaTypes = [kUTTypeImage as String]
        imagePicker.allowsEditing = false
        self.presentViewController(imagePicker, animated: true, 
            completion: nil)

    }
    
    @IBAction func postMessage(sender: AnyObject) {
        var activityItems: [AnyObject]?

        if (postImage.image != nil) {
            print(postText.text)
            activityItems = [postText.text, postImage.image!]
        } else {
            activityItems = [postText.text]
        }

        let activityController = UIActivityViewController(activityItems: 
            activityItems!, applicationActivities: nil)
        self.presentViewController(activityController, animated: true, 
            completion: nil)

    }
    
    func imagePickerController(picker: UIImagePickerController,
       didFinishPickingMediaWithInfo info: [String : AnyObject]) {
        self.dismissViewControllerAnimated(true, completion: nil)
        let image = info[UIImagePickerControllerOriginalImage] as! UIImage
        postImage.image = image
    }

    func imagePickerControllerDidCancel(picker: 
        UIImagePickerController) {
        self.dismissViewControllerAnimated(true, completion: nil)
    }

    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
        postText.endEditing(true)
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

