//
//  ViewController.swift
//  StackViewDemo
//
//  Created by Neil Smyth on 10/11/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var cupStackView: UIStackView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    @IBAction func addCup(sender: AnyObject) {

        let cupImage = UIImageView(image: UIImage(named: "RedCoffeeCup"))
        cupImage.contentMode = .ScaleAspectFit

        UIView.animateWithDuration(0.75, animations: {
            self.cupStackView.addArrangedSubview(cupImage)
            self.cupStackView.layoutIfNeeded()
        })

    }
    
    @IBAction func removeCup(sender: AnyObject) {
        let lastAddedCup = self.cupStackView.arrangedSubviews.last

        if let cup = lastAddedCup
        {
            UIView.animateWithDuration(0.25, animations: {
                self.cupStackView.removeArrangedSubview(cup)
                cup.removeFromSuperview()
                self.cupStackView.layoutIfNeeded()
            })
        }

    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

