//
//  SecondViewController.swift
//  StateApp
//
//  Created by Neil Smyth on 9/3/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class SecondViewController: UIViewController {

    @IBOutlet weak var myTextView: UITextView!
    var thirdViewController: UIViewController?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        thirdViewController = ThirdViewController(nibName: 
                    "ThirdViewController", bundle: nil)

    }

    override func encodeRestorableStateWithCoder(coder: NSCoder) {
        coder.encodeObject(myTextView.text, forKey:"UnsavedText")
        super.encodeRestorableStateWithCoder(coder)
    }

    override func decodeRestorableStateWithCoder(coder: NSCoder) {

        if let decodedObj = coder.decodeObjectForKey("UnsavedText") {
            myTextView.text = decodedObj as! String
        }
        super.decodeRestorableStateWithCoder(coder)
    }

    @IBAction func displayVC3(sender: AnyObject) {
        self.navigationController?.pushViewController(
                thirdViewController!, animated: true)

    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

