//
//  ViewController.swift
//  StoreKitDemo
//
//  Created by Neil Smyth on 9/9/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import StoreKit

class ViewController: UIViewController, SKStoreProductViewControllerDelegate {

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    @IBAction func showStoreView(sender: AnyObject) {
        let storeViewController = SKStoreProductViewController()
        storeViewController.delegate = self

        let parameters = [SKStoreProductParameterITunesItemIdentifier : 
                NSNumber(integer: 676059878)]

        storeViewController.loadProductWithParameters(parameters, 
            completionBlock: {result, error in
            if result {
                self.presentViewController(storeViewController, 
                animated: true, completion: nil)
            }

        })
    }

    func productViewControllerDidFinish(viewController:
        SKStoreProductViewController) {
            viewController.dismissViewControllerAnimated(true, 
                completion: nil)
    }

    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

