//
//  AttractionDetailViewController.swift
//  TableViewStory
//
//  Created by Neil Smyth on 8/28/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class AttractionDetailViewController: UIViewController {

    var webSite: String?

    @IBOutlet weak var webView: UIWebView!
    
    override func viewDidLoad() {
        super.viewDidLoad()

        if let address = webSite {
            let webURL = NSURL(string: address)
            let urlRequest = NSURLRequest(URL: webURL!)
            webView.loadRequest(urlRequest)
        }

    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    override func previewActionItems() -> [UIPreviewActionItem] {

        let action1 = UIPreviewAction(title: "Action One", 
                style: .Destructive, 
                handler: { previewAction, viewController in 
                    print("Action One Selected")
                })

        let action2 = UIPreviewAction(title: "Action Two", 
                style: .Selected, 
                handler: { previewAction, viewController in 
                    print("Action Two Selected")
                })

        let groupAction1 = UIPreviewAction(title: "Group Action One", 
                  style: .Default, 
                  handler: { previewAction, viewController in 
                    print("Group Action One Selected")
                  })

        let groupAction2 = UIPreviewAction(title: "Group Action Two", 
                  style: .Default, 
                  handler: { previewAction, viewController in 
                    print("Group Action Two Selected")
                  })

        let groupActions = UIPreviewActionGroup(title: "My Action Group...", 
                    style: .Default, 
                    actions: [groupAction1, groupAction2])

        return [action1, action2, groupActions]
    }


    /*
    // MARK: - Navigation

    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
    }
    */

}
