//
//  AttractionTableViewController+UIViewControllerPreviewing.swift
//  TableViewStory
//
//  Created by Neil Smyth on 10/5/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

extension AttractionTableViewController: 
	UIViewControllerPreviewingDelegate {

    func previewingContext(previewingContext: UIViewControllerPreviewing, viewControllerForLocation location: CGPoint) -> UIViewController? {

        guard let indexPath = tableView.indexPathForRowAtPoint(location),
            cell = tableView.cellForRowAtIndexPath(indexPath) else { 
            return nil }

        guard let detailViewController = 
              storyboard?.instantiateViewControllerWithIdentifier(
            "AttractionDetailViewController") as? 
                AttractionDetailViewController else { return nil }

        detailViewController.webSite = webAddresses[indexPath.row]
        detailViewController.preferredContentSize = 
        CGSize(width: 0.0, height: 600)

        previewingContext.sourceRect = cell.frame

        return detailViewController
    }

    func previewingContext(previewingContext: UIViewControllerPreviewing, commitViewController viewControllerToCommit: UIViewController) {
      
        showViewController(viewControllerToCommit, sender: self)
    }

}

