//
//  ViewController.swift
//  Touch
//
//  Created by Neil Smyth on 9/2/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var methodStatus: UILabel!
    @IBOutlet weak var touchStatus: UILabel!
    @IBOutlet weak var tapStatus: UILabel!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
        let touchCount = touches.count
        let touch = touches.first
        let tapCount = touch!.tapCount

        methodStatus.text = "touchesBegan"
        touchStatus.text = "\(touchCount) touches"
        tapStatus.text = "\(tapCount) taps"
    }

    override func touchesMoved(touches: Set<UITouch>, withEvent event: UIEvent?) {
        let touchCount = touches.count
        let touch = touches.first
        let tapCount = touch!.tapCount

        methodStatus.text = "touchesMoved";
        touchStatus.text = "\(touchCount) touches"
        tapStatus.text = "\(tapCount) taps"

        if let eventObj = event {
           for coalescedTouch in eventObj.coalescedTouchesForTouch(touch!)! {
                let point = coalescedTouch.locationInView(self.view)
                print("Coalesed location X = \(point.x), Y = \(point.y)")
            }
            print("============")
        }

    }

    override func touchesEnded(touches: Set<UITouch>, withEvent event: UIEvent?) {
        let touchCount = touches.count
        let touch = touches.first
        let tapCount = touch!.tapCount

        methodStatus.text = "touchesEnded";
        touchStatus.text = "\(touchCount) touches"
        tapStatus.text = "\(tapCount) taps"
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

