//
//  ViewController.swift
//  TouchID
//
//  Created by Neil Smyth on 9/3/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import LocalAuthentication

class ViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    @IBAction func testTouchID(sender: AnyObject) {
        let context = LAContext()

        var error: NSError?

        if context.canEvaluatePolicy(
		LAPolicy.DeviceOwnerAuthenticationWithBiometrics, 
			error: &error) {

            context.evaluatePolicy(
                LAPolicy.DeviceOwnerAuthenticationWithBiometrics,
                    localizedReason: "Access requires authentication",
			reply: {(success, error) in
                dispatch_async(dispatch_get_main_queue()) {
                
                    if error != nil {

                        switch error!.code {

                            case LAError.SystemCancel.rawValue:
                                self.notifyUser("Session cancelled", 
                        err: error?.localizedDescription)

                            case LAError.UserCancel.rawValue:
                            self.notifyUser("Please try again", 
                          err: error?.localizedDescription)

                            case LAError.UserFallback.rawValue:
                                self.notifyUser("Authentication", 
                        err: "Password option selected")
                                // Custom code to obtain password here

                            default:
                                self.notifyUser("Authentication failed", 
                        err: error?.localizedDescription)
                        }

                    } else {
                        self.notifyUser("Authentication Successful", 
                    err: "You now have full access")
                    }
                }
            })


        } else {
	      // Device cannot use TouchID
            switch error!.code{

            case LAError.TouchIDNotEnrolled.rawValue:
                notifyUser("TouchID is not enrolled", 
			err: error?.localizedDescription)

            case LAError.PasscodeNotSet.rawValue:
                notifyUser("A passcode has not been set", 
			err: error?.localizedDescription)

            default:
                notifyUser("TouchID not available", 
			err: error?.localizedDescription)

            }
        }
    }
    
    func notifyUser(msg: String, err: String?) {
        let alert = UIAlertController(title: msg, 
            message: err, 
            preferredStyle: UIAlertControllerStyle.Alert)

        let cancelAction = UIAlertAction(title: "OK", 
            style: .Cancel, handler: nil)

        alert.addAction(cancelAction)

        self.presentViewController(alert, animated: true, 
                completion: nil)
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

