//
//  ViewController.swift
//  TouchMotion
//
//  Created by Neil Smyth on 9/2/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    @IBOutlet weak var xCoord: UILabel!
    @IBOutlet weak var yCoord: UILabel!

    var startPoint: CGPoint?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
    }

    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
        if let theTouch = touches.first {
            startPoint = theTouch.locationInView(self.view)

            let x = startPoint!.x
            let y = startPoint!.y

            xCoord.text = ("x = \(x)")
            yCoord.text = ("y = \(y)")
        }
    }

    override func touchesMoved(touches: Set<UITouch>, withEvent event: UIEvent?) {
        
        if let theTouch = touches.first {

            let touchLocation = theTouch.locationInView(self.view)
            let x = touchLocation.x
            let y = touchLocation.y

            xCoord.text = ("x = \(x)")
            yCoord.text = ("y = \(y)")
        }
    }

    override func touchesEnded(touches: Set<UITouch>, withEvent event: UIEvent?) {
        
        if let theTouch = touches.first {

            let endPoint = theTouch.locationInView(self.view)
            let x = endPoint.x
            let y = endPoint.y

            xCoord.text = ("x = \(x)")
            yCoord.text = ("y = \(y)")
        }
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

