//
//  ViewController.swift
//  TwitterApp
//
//  Created by Neil Smyth on 9/8/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import Social
import Accounts

class ViewController: UIViewController, UITableViewDataSource, UITableViewDelegate {

    @IBOutlet weak var tweetTableView: UITableView!
    
    var dataSource = [AnyObject]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        tweetTableView.registerClass(UITableViewCell.self,
            forCellReuseIdentifier: "Cell")
        getTimeLine()
        
        tweetTableView.estimatedRowHeight = 50

    }
    
    func getTimeLine() {

        let account = ACAccountStore()
        let accountType = account.accountTypeWithAccountTypeIdentifier(
            ACAccountTypeIdentifierTwitter)

        account.requestAccessToAccountsWithType(accountType, options: nil, 
            completion: {(success: Bool, error: NSError!) -> Void in

            if success {
                let arrayOfAccounts = 
            account.accountsWithAccountType(accountType)

                if arrayOfAccounts.count > 0 {
                    let twitterAccount = arrayOfAccounts.last as! ACAccount

                    let requestURL = NSURL(string: 
        "https://api.twitter.com/1.1/statuses/user_timeline.json")

                    let parameters = ["screen_name" : "@techotopia",
                        "include_rts" : "0",
                        "trim_user" : "1",
                        "count" : "20"]

                    let postRequest = SLRequest(forServiceType: 
                SLServiceTypeTwitter, 
                requestMethod: SLRequestMethod.GET, 
                URL: requestURL, 
                parameters: parameters)

                    postRequest.account = twitterAccount

                    postRequest.performRequestWithHandler(
                {(responseData: NSData!, 
                  urlResponse: NSHTTPURLResponse!,
                  error: NSError!) -> Void in
                    
                    do {
                        try self.dataSource = NSJSONSerialization.JSONObjectWithData(responseData, options: NSJSONReadingOptions.MutableLeaves) as! [AnyObject]
                        
                        if self.dataSource.count != 0 {
                            dispatch_async(dispatch_get_main_queue()) {
                                self.tweetTableView.reloadData()
                            }
                        }
                    } catch let error as NSError {
                        print("Data serialization error: \(error.localizedDescription)")
                    }
                  })
                }
            } else {
                print("Failed to access account")
             }
        })
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }

    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return dataSource.count
    }

    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {

        let cell =
           tableView.dequeueReusableCellWithIdentifier("Cell")
        let row = indexPath.row
        let tweet = self.dataSource[row] as! NSDictionary
        cell!.textLabel!.text = tweet.objectForKey("text") as? String
        cell!.textLabel!.numberOfLines = 0
        return cell!
    }
}

