//
//  ViewController.swift
//  UIKitDynamics
//
//  Created by Neil Smyth on 9/3/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    var blueBoxView: UIView?
    var redBoxView: UIView?

    var animator: UIDynamicAnimator?
    var currentLocation: CGPoint?
    var attachment: UIAttachmentBehavior? 

    override func viewDidLoad() {
        super.viewDidLoad()
        var frameRect = CGRectMake(10, 20, 80, 80)
        blueBoxView = UIView(frame: frameRect)
        blueBoxView?.backgroundColor = UIColor.blueColor()

        frameRect = CGRectMake(150, 20, 60, 60)
        redBoxView = UIView(frame: frameRect)
        redBoxView?.backgroundColor = UIColor.redColor()

        self.view.addSubview(blueBoxView!)
        self.view.addSubview(redBoxView!)

        animator = UIDynamicAnimator(referenceView: self.view)

        let gravity = UIGravityBehavior(items: [blueBoxView!, 
                                redBoxView!])
        let vector = CGVectorMake(0.0, 1.0)
        gravity.gravityDirection = vector

        let collision = UICollisionBehavior(items: [blueBoxView!, 
                                redBoxView!])
        collision.translatesReferenceBoundsIntoBoundary = true
        let behavior = UIDynamicItemBehavior(items: [blueBoxView!])
        behavior.elasticity = 0.5
        let boxAttachment = UIAttachmentBehavior(item: blueBoxView!,
                        attachedToItem: redBoxView!)
        boxAttachment.frequency = 4.0
        boxAttachment.damping = 0.0

        animator?.addBehavior(boxAttachment)

        animator?.addBehavior(behavior)
        animator?.addBehavior(collision)
        animator?.addBehavior(gravity)
    }

    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {

        if let theTouch = touches.first {
            currentLocation = theTouch.locationInView(self.view)
            let offset = UIOffsetMake(20, 20)
            attachment = UIAttachmentBehavior(item: blueBoxView!, 
                    offsetFromCenter: offset,
                    attachedToAnchor: currentLocation!)

            animator?.addBehavior(attachment!)
        }
    }

    override func touchesMoved(touches: Set<UITouch>, withEvent event: UIEvent?) {
        if let theTouch = touches.first {

            currentLocation = theTouch.locationInView(self.view)
            attachment?.anchorPoint = currentLocation!
        }
    }

    override func touchesEnded(touches: Set<UITouch>, withEvent event: UIEvent?) {
        animator?.removeBehavior(attachment!)
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

