//
//  ViewController.swift
//  iAdDemo
//
//  Created by Neil Smyth on 9/3/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit
import iAd

class ViewController: UIViewController, ADBannerViewDelegate {

    var rectangleAdView: ADBannerView?

    override func viewDidLoad() {
        super.viewDidLoad()
        self.canDisplayBannerAds = true

        rectangleAdView = ADBannerView(adType: ADAdType.MediumRectangle)
        rectangleAdView?.delegate = self
    }

    func bannerViewDidLoadAd(banner: ADBannerView!) {
        self.view.addSubview(banner)
        self.view.layoutIfNeeded()
    }

    func bannerView(banner: ADBannerView!, didFailToReceiveAdWithError error: NSError!) {
        banner.removeFromSuperview()
        self.view.layoutIfNeeded()
    }

    override func prepareForSegue(segue: UIStoryboardSegue, sender: AnyObject?) {
        let destination = segue.destinationViewController 
        destination.interstitialPresentationPolicy = 
                ADInterstitialPresentationPolicy.Automatic
    }


    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

