//
//  ViewController.swift
//  iCloudKeys
//
//  Created by Neil Smyth on 9/1/15.
//  Copyright © 2015 eBookFrenzy. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    var keyStore: NSUbiquitousKeyValueStore?
    @IBOutlet weak var textField: UITextField!
    
    override func viewDidLoad() {
        super.viewDidLoad()
    keyStore = NSUbiquitousKeyValueStore()

    let storedString = keyStore?.stringForKey("MyString")

    if let stringValue = storedString {
        textField.text = stringValue
    }

    NSNotificationCenter.defaultCenter().addObserver(self,
        selector: #selector(ViewController.ubiquitousKeyValueStoreDidChange(_:)),
        name: NSUbiquitousKeyValueStoreDidChangeExternallyNotification,
        object: keyStore)
    }

    func ubiquitousKeyValueStoreDidChange(notification: NSNotification) {

        let alert = UIAlertController(title: "Change detected",
                message: "iCloud key-value-store change detected",
            preferredStyle: UIAlertControllerStyle.Alert)

        let cancelAction = UIAlertAction(title: "OK",
                style: .Cancel, handler: nil)

        alert.addAction(cancelAction)
        self.presentViewController(alert, animated: true,
                    completion: nil)
        textField.text = keyStore?.stringForKey("MyString")
    }

    @IBAction func saveKey(sender: AnyObject) {
        keyStore?.setString(textField.text, forKey: "MyString")
        keyStore?.synchronize()

    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }


}

